/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.commands.source;

import java.util.Locale;
import java.util.UUID;
import net.impactdev.impactor.api.commands.CommandSource;
import net.impactdev.impactor.api.platform.players.PlatformPlayer;
import net.impactdev.impactor.api.platform.sources.PlatformSource;
import net.kyori.adventure.audience.MessageType;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.inventory.Book;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.TitlePart;
import org.jetbrains.annotations.NotNull;

public abstract class ImpactorCommandSource<S>
implements CommandSource {
    private final PlatformSource source;
    private final S delegate;

    public ImpactorCommandSource(PlatformSource source2, S delegate) {
        this.source = source2;
        this.delegate = delegate;
    }

    public S delegate() {
        return this.delegate;
    }

    @Override
    public UUID uuid() {
        return this.source.uuid();
    }

    @Override
    public Component name() {
        return this.source.name();
    }

    @Override
    public PlatformSource source() {
        return this.source;
    }

    @Override
    public PlatformPlayer player() {
        if (this.source instanceof PlatformPlayer) {
            return (PlatformPlayer)this.source;
        }
        throw new IllegalStateException("Source is not a player");
    }

    protected boolean isConsole() {
        return this.uuid().equals(PlatformSource.SERVER_UUID);
    }

    protected boolean isPlayer() {
        return this.source instanceof PlatformPlayer || this.uuid().equals(PlatformSource.SERVER_UUID);
    }

    @Override
    public Locale locale() {
        return this.source.locale();
    }

    public void sendMessage(@NotNull Identity source2, @NotNull Component message, @NotNull MessageType type) {
        this.source.sendMessage(source2, message, type);
    }

    public void sendActionBar(@NotNull Component message) {
        this.source.sendActionBar(message);
    }

    public void sendPlayerListHeaderAndFooter(@NotNull Component header, @NotNull Component footer) {
        this.source.sendPlayerListHeaderAndFooter(header, footer);
    }

    public <T> void sendTitlePart(@NotNull TitlePart<T> part, @NotNull T value) {
        this.source.sendTitlePart(part, value);
    }

    public void showBossBar(@NotNull BossBar bar) {
        this.source.showBossBar(bar);
    }

    public void hideBossBar(@NotNull BossBar bar) {
        this.source.hideBossBar(bar);
    }

    public void clearTitle() {
        this.source.clearTitle();
    }

    public void resetTitle() {
        this.source.resetTitle();
    }

    public void playSound(@NotNull Sound sound) {
        this.source.playSound(sound);
    }

    public void playSound(@NotNull Sound sound, double x, double y, double z) {
        this.source.playSound(sound, x, y, z);
    }

    public void playSound(@NotNull Sound sound, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Sound.Emitter emitter) {
        this.source.playSound(sound, emitter);
    }

    public void openBook(@NotNull Book book) {
        this.source.openBook(book);
    }
}

